/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.client.screen.widgets.ContainerWidget;
import dev.toma.gunsrpg.client.screen.widgets.EnumButton;
import dev.toma.gunsrpg.client.screen.widgets.ScrollableListWidget;
import dev.toma.gunsrpg.common.container.TurretContainer;
import dev.toma.gunsrpg.common.entity.TurretEntity;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_TurretSettingsPacket;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TurretScreen
extends ContainerScreen<TurretContainer> {
    private static final ResourceLocation TEXTURE = GunsRPG.makeResource("textures/screen/turret.png");
    private static final ITextComponent TEXT_ADD = new TranslationTextComponent("screen.gunsrpg.button.add");
    private static final ITextComponent TEXT_ENTER_PLAYERNAME = new TranslationTextComponent("screen.gunsrpg.text_field.enter_playername");
    private TurretEntity turret;
    private TextFieldWidget playerNameField;

    public TurretScreen(TurretContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 179;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        Entity entity = this.field_230706_i_.field_71441_e.func_73045_a(((TurretContainer)this.field_147002_h).getEntityId());
        if (!(entity instanceof TurretEntity)) {
            this.field_230706_i_.func_147108_a(null);
            GunsRPG.log.error("Unable to display turret screen, invalid entity received: Id {}, Entity {}", (Object)((TurretContainer)this.field_147002_h).getEntityId(), (Object)entity);
            return;
        }
        this.turret = (TurretEntity)entity;
        List whitelistedPlayers = this.turret.getNameCache().entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue())).sorted(Comparator.comparing(Pair::getSecond)).collect(Collectors.toList());
        ScrollableListWidget whitelist = (ScrollableListWidget)this.func_230480_a_(new ScrollableListWidget<Pair, WhitelistEntryWidget>(this.field_147003_i + 81, this.field_147009_r + 7, 88, 60, whitelistedPlayers, (entry, entryX, entryY, entryWidth, entryHeight) -> {
            RemoveWhitelistEntryHandler handler = this::removeWhitelistEntryClicked;
            return new WhitelistEntryWidget(entryX, entryY, entryWidth, entryHeight, this.field_230712_o_, (Pair<UUID, String>)entry, handler);
        }));
        whitelist.setEntryHeight(20);
        EnumButton selector = (EnumButton)this.func_230480_a_((Widget)new EnumButton<TurretEntity.TargettingMode>(this.field_147003_i + 7, this.field_147009_r + 47, 72, 20, this.turret.getTargettingMode(), this.turret.getAvailableTargettingModes(), this::targettingModeChanged));
        selector.setToComponentTransformer(EnumButton::upperCaseFormat);
        Button send = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 109, this.field_147009_r + 69, 60, 20, TEXT_ADD, this::addToWhitelistClicked));
        String suggestion = TEXT_ENTER_PLAYERNAME.getString();
        this.playerNameField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 7, this.field_147009_r + 69, 100, 20, StringTextComponent.field_240750_d_));
        this.playerNameField.func_195612_c(suggestion);
        this.playerNameField.func_212954_a(value -> {
            this.playerNameField.func_195612_c(value.isEmpty() ? suggestion : "");
            send.field_230693_o_ = !value.isEmpty() && this.isValidPlayerName((String)value);
        });
        send.field_230693_o_ = false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        IGuiEventListener listener = this.func_241217_q_();
        if (listener instanceof TextFieldWidget && ((TextFieldWidget)listener).func_230999_j_()) {
            listener.func_231046_a_(keyCode, scanCode, modifiers);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    private void removeWhitelistEntryClicked(UUID uuid) {
        this.turret.removeFromWhitelist(uuid);
        NetworkManager.sendServerPacket(C2S_TurretSettingsPacket.whitelistPacket(this.turret, C2S_TurretSettingsPacket.WhitelistOperation.REMOVE, uuid));
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    private void targettingModeChanged(TurretEntity.TargettingMode mode) {
        this.turret.setTargettingMode(mode);
        NetworkManager.sendServerPacket(C2S_TurretSettingsPacket.setTargettingMode(this.turret, mode));
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    private void addToWhitelistClicked(Button button) {
        String name = this.playerNameField.func_146179_b();
        UUID playerId = this.getPlayerByName(name);
        if (playerId != null) {
            this.turret.addToWhitelist(playerId);
            NetworkManager.sendServerPacket(C2S_TurretSettingsPacket.whitelistPacket(this.turret, C2S_TurretSettingsPacket.WhitelistOperation.ADD, playerId));
        }
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    private boolean isValidPlayerName(String name) {
        return this.getPlayerByName(name) != null;
    }

    private UUID getPlayerByName(String name) {
        return this.field_230706_i_.field_71441_e.func_217369_A().stream().filter(player -> player.func_200200_C_().getString().equalsIgnoreCase(name)).findFirst().map(Entity::func_110124_au).orElse(null);
    }

    @FunctionalInterface
    private static interface RemoveWhitelistEntryHandler {
        public void handleRemoval(UUID var1);
    }

    private static final class WhitelistEntryWidget
    extends ContainerWidget {
        private final FontRenderer font;
        private final ITextComponent name;
        private final Button removeButton;

        public WhitelistEntryWidget(int x, int y, int width, int height, FontRenderer font, Pair<UUID, String> entry, RemoveWhitelistEntryHandler handler) {
            super(x, y, width, height);
            this.font = font;
            this.name = new StringTextComponent((String)entry.getSecond());
            this.removeButton = new Button(x + width - 20, y, 20, 20, (ITextComponent)new StringTextComponent("x"), btn -> {
                UUID uuid = (UUID)entry.getFirst();
                handler.handleRemoval(uuid);
            });
            this.addWidget(this.removeButton);
            this.setRemoveButtonVisible(false);
        }

        @Override
        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            this.setRemoveButtonVisible(this.field_230692_n_);
            if (this.field_230692_n_) {
                WhitelistEntryWidget.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)0x66FFFFFF);
                float f = this.field_230690_l_ + 3;
                float f2 = this.field_230691_m_;
                this.font.getClass();
                this.font.func_243246_a(stack, this.name, f, f2 + (float)(this.field_230689_k_ - 9) / 2.0f, 0xFFFF00);
            } else {
                float f = this.field_230690_l_ + 3;
                float f3 = this.field_230691_m_;
                this.font.getClass();
                this.font.func_243248_b(stack, this.name, f, f3 + (float)(this.field_230689_k_ - 9) / 2.0f, 0xFFFFFF);
            }
            super.func_230431_b_(stack, mouseX, mouseY, partialTicks);
        }

        private void setRemoveButtonVisible(boolean visible) {
            this.removeButton.field_230694_p_ = visible;
            this.removeButton.field_230693_o_ = visible;
        }
    }
}

